package com.ruoyi.web.controller.business;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;

import com.deepoove.poi.XWPFTemplate;
import com.ruoyi.common.config.RuoYiConfig;
import com.ruoyi.common.constant.Constants;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.MoneyConverter;
import com.ruoyi.common.utils.file.FileUploadUtils;
import com.ruoyi.framework.config.ServerConfig;
import com.ruoyi.system.domain.business.BaseContractInfo;
import com.ruoyi.system.domain.business.BaseContractPeriodsInfo;
import com.ruoyi.system.domain.business.BaseSubjectInfo;
import com.ruoyi.system.domain.business.vo.ContractCollectVo;
import com.ruoyi.system.service.business.IBaseContractInfoService;

import com.ruoyi.system.service.business.IBaseSubjectInfoService;

import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 合同信息Controller
 *
 * @author gm
 * @date 2025-02-10
 */
@RestController
@RequestMapping("/contract/info")
public class BaseContractInfoController extends BaseController {
    @Autowired
    private IBaseContractInfoService baseContractInfoService;

    @Autowired
    private IBaseSubjectInfoService baseSubjectInfoService;

    @Autowired
    private ServerConfig serverConfig;

    /**
     * 查询合同信息列表
     */
    //  // @PreAuthorize("@ss.hasPermi('contract:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(BaseContractInfo baseContractInfo) {
        startPage();
        List<BaseContractInfo> list = baseContractInfoService.selectBaseContractInfoList(baseContractInfo);
        return getDataTable(list);
    }

    /**
     * 导出合同信息列表
     */
    //  // @PreAuthorize("@ss.hasPermi('contract:info:export')")
    @Log(title = "合同信息" , businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BaseContractInfo baseContractInfo) {
        List<BaseContractInfo> list = baseContractInfoService.selectBaseContractInfoList(baseContractInfo);
        ExcelUtil<BaseContractInfo> util = new ExcelUtil<BaseContractInfo>(BaseContractInfo.class);
        util.exportExcel(response, list, "合同信息数据");
    }

    /**
     * 获取合同信息详细信息
     */
    //  // @PreAuthorize("@ss.hasPermi('contract:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return success(baseContractInfoService.selectBaseContractInfoById(id));
    }

    /**
     * 新增合同信息
     */
    // // @PreAuthorize("@ss.hasPermi('contract:info:add')")
    @Log(title = "合同信息" , businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BaseContractInfo baseContractInfo) {
        baseContractInfo.setCreateBy(getLoginUser().getUser().getNickName());
        baseContractInfo.setCreateTime(new Date());
        return toAjax(baseContractInfoService.insertBaseContractInfo(baseContractInfo));
    }

    /**
     * 修改合同信息
     */
    // // @PreAuthorize("@ss.hasPermi('contract:info:edit')")
    @Log(title = "合同信息" , businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BaseContractInfo baseContractInfo) {
        baseContractInfo.setUpdateTime(new Date());
        baseContractInfo.setUpdateBy(getLoginUser().getUser().getNickName());
        return toAjax(baseContractInfoService.updateBaseContractInfo(baseContractInfo,getLoginUser().getUser()));
    }

    /**
     * 删除合同信息
     */
    // // @PreAuthorize("@ss.hasPermi('contract:info:remove')")
    @Log(title = "合同信息" , businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(baseContractInfoService.deleteBaseContractInfoByIds(ids));
    }

    @GetMapping(value = "/audit/list")
    public TableDataInfo getInfo(BaseContractInfo baseContractInfo) {
        startPage();
        List<BaseContractInfo> baseContractInfos = baseContractInfoService.selectBaseContractAuditList(baseContractInfo, getLoginUser());
        return getDataTable(baseContractInfos);
    }


    @GetMapping(value = "/collect")
    public AjaxResult collect(Long contractId) {
        ContractCollectVo contractCollectVo = baseContractInfoService.getCollect(contractId);
        return success(contractCollectVo);
    }

    @PostMapping(value = "/lookContract")
    public ResponseEntity lookContract(@RequestBody BaseContractInfo baseContractInfo) {
        BaseContractInfo baseContract = baseContractInfoService.selectBaseContractInfoById(baseContractInfo.getId());
        BaseSubjectInfo baseSubjectInfo = baseSubjectInfoService.selectBaseSubjectInfoById(baseContract.getSubjectId());

        String templateName = null;

        if (baseSubjectInfo.getZtmc().contains("中科软齐")) {
            templateName = "zkrq-template.docx";
        }

        if (baseSubjectInfo.getZtmc().contains("中科软通")) {
            templateName = "zkrt-template.docx";
        }

        if (baseSubjectInfo.getZtmc().contains("中科软盈")) {
            templateName = "zkry-template.docx";
        }

        if (baseSubjectInfo.getZtmc().contains("中科网联")) {
            templateName = "zkwl-template.docx";
        }

        if (baseSubjectInfo.getZtmc().contains("软艺")) {
            templateName = "ry-template.docx";
        }

        try {
            // 1. 加载模板文件
            InputStream inputStream = Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(templateName));
            XWPFTemplate template = XWPFTemplate.compile(inputStream).render(
                    // 2. 构建数据模型
                    new HashMap<String, Object>() {{
                        put("xmmc" , baseContract.getHtmc());
                        put("jf" , baseContract.getjGsmc());
                        put("yf" , baseSubjectInfo.getZtmc());
                        put("htbh" , baseContract.getHtbh());
                        put("qyrq" , DateUtils.dateTime(baseContract.getQysj()));
                        put("jLxr" , baseContract.getjLxr());
                        put("jTxdz" , baseContract.getjTxdz());
                        put("jLxdh" , baseContract.getjLxdh());
                        put("jGsmc" , baseContract.getjGsmc());
                        put("jTxdz" , baseContract.getjTxdz());
                        put("jYb" , baseContract.getjYb());
                        put("jDzyx" , baseContract.getjDzyj());
                        put("jHkr" , baseContract.getjHkr());
                        put("jKhyh" , baseContract.getjKhyh());
                        put("jYhzh" , baseContract.getjYhzh());
                        put("jSwdjh" , baseContract.getjSwdjh());
                        put("jLxr" , baseContract.getjLxr());
                        put("jLxdh" , baseContract.getjLxdh());
                        put("htmc" , baseContract.getHtmc());
                        put("htze" , baseContract.getHtze());
                        put("hezedx" , MoneyConverter.convert(baseContract.getHtze()));
                        if (baseContract.getQs() == 1) {
                            put("qsms" , Constants.YI_QI);
                        }
                        if (baseContract.getQs() == 2) {
                            put("qsms" , Constants.ER_QI);
                        }
                        if (baseContract.getQs() == 3) {
                            put("qsms" , Constants.SAN_QI);
                        }
                        if (baseContract.getQs() == 4) {
                            put("qsms" , Constants.SI_QI);
                        }

                    }});

            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            template.writeAndClose(outputStream);
            byte[] fileBytes = outputStream.toByteArray();

            ByteArrayResource resource = new ByteArrayResource(fileBytes);
            return ResponseEntity.ok()
                    .header(HttpHeaders.CONTENT_DISPOSITION, "attachment;filename=newWord.docx")
                    .contentType(MediaType.APPLICATION_OCTET_STREAM)
                    .contentLength(fileBytes.length)
                    .body(resource);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GetMapping(value = "/period/info")
    public AjaxResult periodInfo(BaseContractInfo baseContractInfo) {
        List<BaseContractPeriodsInfo >  baseContractPeriodsInfos = baseContractInfoService.getPeriodInfo(baseContractInfo);
        return success(baseContractPeriodsInfos);
    }

}
