package com.ruoyi.system.domain.business;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 开票信息对象 base_invoice_info
 *
 * @author gm
 * @date 2025-02-17
 */
public class BaseInvoiceInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 合同id */
    @Excel(name = "合同id")
    private Long contractId;

    /** 合同编号 */
    @Excel(name = "合同编号")
    private String htbh;

    /** 部门id */
    @Excel(name = "部门id")
    private Long bmId;

    /** 部门 */
    @Excel(name = "部门")
    private String bm;

    /** 客户id */
    @Excel(name = "客户id")
    private Long khId;

    /** 客户名称 */
    @Excel(name = "客户名称")
    private String khmc;

    /** 合同名称 */
    @Excel(name = "合同名称")
    private String htmc;

    /** 回款金额 */
    @Excel(name = "回款金额")
    private BigDecimal hkje;

    /** 回款期数 */
    @Excel(name = "回款期数")
    private Long hkqs;

    /** 发票内容 */
    @Excel(name = "发票内容")
    private String fpnr;

    /** 发票类型 */
    @Excel(name = "发票类型")
    private Long fplx;

    /** 发票税率 */
    @Excel(name = "发票税率")
    private BigDecimal fpsl;

    /** 开票金额 */
    @Excel(name = "开票金额")
    private BigDecimal kpje;

    /** 发票税额 */
    @Excel(name = "发票税额")
    private BigDecimal fpse;

    /** 纳税人识别号 */
    @Excel(name = "纳税人识别号")
    private String nsrsbh;

    /** 地址 */
    @Excel(name = "地址")
    private String dz;

    /** 手机号 */
    @Excel(name = "手机号")
    private String sjh;

    /** 开户行 */
    @Excel(name = "开户行")
    private String khh;

    /** 银行账号 */
    @Excel(name = "银行账号")
    private String yhzh;

    /** 收票人姓名 */
    @Excel(name = "收票人姓名")
    private String sprxm;

    /** 收票人电话 */
    @Excel(name = "收票人电话")
    private String sprdh;

    /** 收票人邮箱 */
    @Excel(name = "收票人邮箱")
    private String spryx;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 发票状态 1 待审核 2 驳回 3 审核通过 3 已冲红 */
    @Excel(name = "发票状态 1 待审核 2 驳回 3 审核通过 3 已冲红")
    private Long fpzt;

    /** 申请人 */
    @Excel(name = "申请人")
    private String sqr;

    /** 开票时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开票时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date kpsj;

    /** 代付款协议 */
    @Excel(name = "代付款协议")
    private String dfkxy;

    /** 电子回单 */
    @Excel(name = "电子回单")
    private String dzhd;

    /** 发票附件 */
    @Excel(name = "发票附件")
    private String fpfj;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setContractId(Long contractId)
    {
        this.contractId = contractId;
    }

    public Long getContractId()
    {
        return contractId;
    }
    public void setHtbh(String htbh)
    {
        this.htbh = htbh;
    }

    public String getHtbh()
    {
        return htbh;
    }
    public void setBmId(Long bmId)
    {
        this.bmId = bmId;
    }

    public Long getBmId()
    {
        return bmId;
    }
    public void setBm(String bm)
    {
        this.bm = bm;
    }

    public String getBm()
    {
        return bm;
    }
    public void setKhId(Long khId)
    {
        this.khId = khId;
    }

    public Long getKhId()
    {
        return khId;
    }
    public void setKhmc(String khmc)
    {
        this.khmc = khmc;
    }

    public String getKhmc()
    {
        return khmc;
    }
    public void setHtmc(String htmc)
    {
        this.htmc = htmc;
    }

    public String getHtmc()
    {
        return htmc;
    }
    public void setHkje(BigDecimal hkje)
    {
        this.hkje = hkje;
    }

    public BigDecimal getHkje()
    {
        return hkje;
    }
    public void setHkqs(Long hkqs)
    {
        this.hkqs = hkqs;
    }

    public Long getHkqs()
    {
        return hkqs;
    }
    public void setFpnr(String fpnr)
    {
        this.fpnr = fpnr;
    }

    public String getFpnr()
    {
        return fpnr;
    }
    public void setFplx(Long fplx)
    {
        this.fplx = fplx;
    }

    public Long getFplx()
    {
        return fplx;
    }
    public void setFpsl(BigDecimal fpsl)
    {
        this.fpsl = fpsl;
    }

    public BigDecimal getFpsl()
    {
        return fpsl;
    }
    public void setKpje(BigDecimal kpje)
    {
        this.kpje = kpje;
    }

    public BigDecimal getKpje()
    {
        return kpje;
    }
    public void setFpse(BigDecimal fpse)
    {
        this.fpse = fpse;
    }

    public BigDecimal getFpse()
    {
        return fpse;
    }
    public void setNsrsbh(String nsrsbh)
    {
        this.nsrsbh = nsrsbh;
    }

    public String getNsrsbh()
    {
        return nsrsbh;
    }
    public void setDz(String dz)
    {
        this.dz = dz;
    }

    public String getDz()
    {
        return dz;
    }
    public void setSjh(String sjh)
    {
        this.sjh = sjh;
    }

    public String getSjh()
    {
        return sjh;
    }
    public void setKhh(String khh)
    {
        this.khh = khh;
    }

    public String getKhh()
    {
        return khh;
    }
    public void setYhzh(String yhzh)
    {
        this.yhzh = yhzh;
    }

    public String getYhzh()
    {
        return yhzh;
    }
    public void setSprxm(String sprxm)
    {
        this.sprxm = sprxm;
    }

    public String getSprxm()
    {
        return sprxm;
    }
    public void setSprdh(String sprdh)
    {
        this.sprdh = sprdh;
    }

    public String getSprdh()
    {
        return sprdh;
    }
    public void setSpryx(String spryx)
    {
        this.spryx = spryx;
    }

    public String getSpryx()
    {
        return spryx;
    }
    public void setBz(String bz)
    {
        this.bz = bz;
    }

    public String getBz()
    {
        return bz;
    }
    public void setFpzt(Long fpzt)
    {
        this.fpzt = fpzt;
    }

    public Long getFpzt()
    {
        return fpzt;
    }
    public void setSqr(String sqr)
    {
        this.sqr = sqr;
    }

    public String getSqr()
    {
        return sqr;
    }
    public void setKpsj(Date kpsj)
    {
        this.kpsj = kpsj;
    }

    public Date getKpsj()
    {
        return kpsj;
    }
    public void setDfkxy(String dfkxy)
    {
        this.dfkxy = dfkxy;
    }

    public String getDfkxy()
    {
        return dfkxy;
    }
    public void setDzhd(String dzhd)
    {
        this.dzhd = dzhd;
    }

    public String getDzhd()
    {
        return dzhd;
    }
    public void setFpfj(String fpfj)
    {
        this.fpfj = fpfj;
    }

    public String getFpfj()
    {
        return fpfj;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("contractId", getContractId())
            .append("htbh", getHtbh())
            .append("bmId", getBmId())
            .append("bm", getBm())
            .append("khId", getKhId())
            .append("khmc", getKhmc())
            .append("htmc", getHtmc())
            .append("hkje", getHkje())
            .append("hkqs", getHkqs())
            .append("fpnr", getFpnr())
            .append("fplx", getFplx())
            .append("fpsl", getFpsl())
            .append("kpje", getKpje())
            .append("fpse", getFpse())
            .append("nsrsbh", getNsrsbh())
            .append("dz", getDz())
            .append("sjh", getSjh())
            .append("khh", getKhh())
            .append("yhzh", getYhzh())
            .append("sprxm", getSprxm())
            .append("sprdh", getSprdh())
            .append("spryx", getSpryx())
            .append("bz", getBz())
            .append("fpzt", getFpzt())
            .append("sqr", getSqr())
            .append("kpsj", getKpsj())
            .append("dfkxy", getDfkxy())
            .append("dzhd", getDzhd())
            .append("fpfj", getFpfj())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .append("updateTime", getUpdateTime())
            .append("updateBy", getUpdateBy())
            .toString();
    }
}
