package com.ruoyi.system.domain.business;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 合同期限对象 base_contract_periods_info
 *
 * @author gm
 * @date 2025-02-10
 */
public class BaseContractPeriodsInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 合同id */
    @Excel(name = "合同id")
    private Long contractId;

    /** 期数 */
    @Excel(name = "期数")
    private String qs;

    /** 金额 */
    @Excel(name = "金额")
    private BigDecimal je;

    /** 描述 */
    @Excel(name = "描述")
    private String ms;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setContractId(Long contractId)
    {
        this.contractId = contractId;
    }

    public Long getContractId()
    {
        return contractId;
    }
    public void setQs(String qs)
    {
        this.qs = qs;
    }

    public String getQs()
    {
        return qs;
    }
    public void setJe(BigDecimal je)
    {
        this.je = je;
    }

    public BigDecimal getJe()
    {
        return je;
    }
    public void setMs(String ms)
    {
        this.ms = ms;
    }

    public String getMs()
    {
        return ms;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("contractId", getContractId())
            .append("qs", getQs())
            .append("je", getJe())
            .append("ms", getMs())
            .toString();
    }
}
