package com.ruoyi.system.domain.business;

import java.math.BigDecimal;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 合同期限对象 base_contract_periods_info
 *
 * @author gm
 * @date 2025-02-10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseContractPeriodsInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 合同id */
    @Excel(name = "合同id")
    private Long contractId;

    /** 期数 */
    @Excel(name = "期数")
    private String qs;

    /** 金额 */
    @Excel(name = "金额")
    private BigDecimal je;

    /** 描述 */
    @Excel(name = "描述")
    private String ms;
}
